<?php
header('Content-Type: application/json');
require_once '../config/config.php';

// Check if user is logged in
if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

try {
    $user_id = $_SESSION['user_id'];
    
    // Check if notifications table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'notifications'");
    if ($stmt->rowCount() === 0) {
        // Table doesn't exist, return empty
        echo json_encode([
            'success' => true,
            'unread_count' => 0,
            'notifications' => [],
            'table_missing' => true
        ]);
        exit;
    }
    
    // Get unread count
    $stmt = $pdo->prepare("SELECT COUNT(*) as unread_count FROM notifications WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
    $stmt->execute([$user_id]);
    $unread = $stmt->fetch();
    
    // Get recent notifications (last 20)
    $stmt = $pdo->prepare("SELECT * FROM notifications WHERE (user_id = ? OR user_id IS NULL) ORDER BY created_at DESC LIMIT 20");
    $stmt->execute([$user_id]);
    $notifications = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'unread_count' => $unread['unread_count'],
        'notifications' => $notifications,
        'table_missing' => false
    ]);
    
} catch (Exception $e) {
    // Return empty on error
    echo json_encode([
        'success' => true,
        'unread_count' => 0,
        'notifications' => [],
        'error' => $e->getMessage()
    ]);
}
