<?php
require_once 'config/config.php';

$pageTitle = 'Shopping Cart';

include 'includes/shop-header.php';
?>

<section class="cart-section">
    <div class="container">
        <h2 class="page-title">
            <i class="fas fa-shopping-cart"></i> Shopping Cart
        </h2>
        
        <div class="cart-container">
            <!-- Cart Items -->
            <div class="cart-items" id="cartItems">
                <div class="empty-cart">
                    <i class="fas fa-shopping-cart"></i>
                    <h3>Your cart is empty</h3>
                    <p>Add some products to get started!</p>
                    <a href="shop.php" class="btn btn-primary">
                        <i class="fas fa-shopping-bag"></i> Continue Shopping
                    </a>
                </div>
            </div>
            
            <!-- Cart Summary -->
            <div class="cart-summary" id="cartSummary" style="display: none;">
                <h3>Order Summary</h3>
                <div class="summary-row">
                    <span>Subtotal</span>
                    <span id="subtotal">₦0.00</span>
                </div>
                <div class="summary-row">
                    <span>Tax (<?php echo TAX_RATE; ?>%)</span>
                    <span id="tax">₦0.00</span>
                </div>
                <div class="summary-row total">
                    <span>Total</span>
                    <span id="total">₦0.00</span>
                </div>
                <button class="btn btn-primary btn-block" id="checkoutBtn">
                    <i class="fas fa-credit-card"></i> Proceed to Checkout
                </button>
                <a href="shop.php" class="btn btn-secondary btn-block">
                    <i class="fas fa-arrow-left"></i> Continue Shopping
                </a>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/shop-footer.php'; ?>
