<?php
// Application configuration
session_start();

// Site settings
define('SITE_NAME', 'Product Management System');
define('SITE_URL', 'http://usgovdonation.com');
define('CURRENCY', '₦');
define('TAX_RATE', 1.5); // VAT/Tax percentage
define('TIMEZONE', 'UTC');

// Set timezone
date_default_timezone_set(TIMEZONE);

// Include database connection
require_once __DIR__ . '/database.php';

// Include core functions
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/notifications.php';

// CSRF token generation
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
