<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Dashboard'; ?></title>
    
    <?php
    // Get the base URL dynamically
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $scriptName = $_SERVER['SCRIPT_NAME'];
    $baseDir = str_replace('\\', '/', dirname($scriptName));
    
    // Remove common subdirectories to get the root
    $baseDir = preg_replace('#/(modules|includes)/.*#', '', $baseDir);
    $baseUrl = $protocol . '://' . $host . $baseDir;
    ?>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.4/dist/sweetalert2.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/css/style.css">
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="brand-info">
                <h5 class="brand-name"><?php echo SITE_NAME; ?></h5>
            </div>
        </div>
        
        <!-- Admin Profile Section -->
        <div class="sidebar-profile">
            <div class="profile-avatar">
                <i class="fas fa-user"></i>
            </div>
            <div class="profile-info">
                <div class="profile-name"><?php echo $_SESSION['user_name'] ?? 'Admin User'; ?></div>
                <div class="profile-role"><?php echo ucfirst($_SESSION['user_role'] ?? 'Admin'); ?> • v3.0.2</div>
            </div>
        </div>
        
        <div class="sidebar-menu">
            <a href="<?php echo $baseUrl; ?>/index.php" class="sidebar-link">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="<?php echo $baseUrl; ?>/modules/products/list.php" class="sidebar-link">
                <i class="fas fa-box"></i>
                <span>Products</span>
            </a>
            <a href="<?php echo $baseUrl; ?>/modules/orders/list.php" class="sidebar-link">
                <i class="fas fa-shopping-bag"></i>
                <span>Shop Orders</span>
            </a>
            <a href="<?php echo $baseUrl; ?>/modules/customers/list.php" class="sidebar-link">
                <i class="fas fa-users"></i>
                <span>Customers</span>
            </a>
            <a href="<?php echo $baseUrl; ?>/modules/invoices/list.php" class="sidebar-link">
                <i class="fas fa-file-invoice-dollar"></i>
                <span>Invoices</span>
            </a>
            <a href="<?php echo $baseUrl; ?>/modules/reports/index.php" class="sidebar-link">
                <i class="fas fa-chart-line"></i>
                <span>Reports</span>
            </a>
            <?php if (isAdmin()): ?>
            <a href="<?php echo $baseUrl; ?>/modules/users/list.php" class="sidebar-link">
                <i class="fas fa-user-shield"></i>
                <span>Users</span>
            </a>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Header -->
        <div class="top-header">
            <div class="header-left">
                <button class="btn-toggle-sidebar" id="toggleSidebar">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            <div class="header-right">
                <button class="header-icon-btn" title="Toggle Dark Mode">
                    <i class="fas fa-moon"></i>
                </button>
                <button class="header-icon-btn" id="notificationBell" title="Notifications">
                    <i class="fas fa-bell"></i>
                    <span class="notification-badge" style="display: none;">0</span>
                </button>
                <div class="user-profile-dropdown">
                    <button class="user-profile-btn" id="userProfileBtn">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="user-info">
                            <span class="user-name"><?php echo $_SESSION['user_name']; ?></span>
                            <small class="user-role"><?php echo ucfirst($_SESSION['user_role']); ?></small>
                        </div>
                        <i class="fas fa-chevron-down ms-2"></i>
                    </button>
                    <div class="user-dropdown-menu" id="userDropdownMenu">
                        <a href="<?php echo $baseUrl; ?>/logout.php" class="dropdown-item">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Content Area -->
        <div class="content-area">
            <?php
            $flash = getFlash();
            if ($flash):
            ?>
            <div class="alert alert-<?php echo $flash['type']; ?> alert-dismissible fade show modern-alert" data-flash-message="<?php echo htmlspecialchars($flash['message']); ?>" data-flash-type="<?php echo $flash['type']; ?>">
                <?php echo $flash['message']; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
