<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Shop'; ?></title>
    
    <?php
    // Get the base URL dynamically
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $scriptName = $_SERVER['SCRIPT_NAME'];
    $baseDir = str_replace('\\', '/', dirname($scriptName));
    $baseDir = preg_replace('#/(modules|includes)/.*#', '', $baseDir);
    $baseUrl = $protocol . '://' . $host . $baseDir;
    ?>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.4/dist/sweetalert2.min.css">
    
    <!-- Shop CSS -->
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/css/shop.css">
    <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/css/style.css">
</head>
<body>
    <!-- Top Header Bar -->
    <div class="top-header">
        <div class="header-left">
            <h1 class="page-title">
                <i class="fas fa-store me-2"></i><?php echo SITE_NAME; ?> - Shop
            </h1>
        </div>
        
        <div class="header-right">
            <button class="header-icon-btn" id="darkModeToggle" title="Toggle Dark Mode">
                <i class="fas fa-moon"></i>
            </button>
            
            <a href="<?php echo $baseUrl; ?>/shop-cart.php" class="header-icon-btn" title="Shopping Cart">
                <i class="fas fa-shopping-cart"></i>
                <span class="notification-badge" id="cartBadge">0</span>
            </a>
            
            <a href="<?php echo $baseUrl; ?>/login.php" class="header-icon-btn" title="Admin Login">
                <i class="fas fa-user-shield"></i>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <main class="main-content" style="margin-left: 0;">
        <div class="content-area">
