<?php
require_once 'config/config.php';
requireLogin();

$pageTitle = 'Dashboard - ' . SITE_NAME;

// Get statistics
$todayStats = getSalesStats($pdo, 'today');
$weekStats = getSalesStats($pdo, 'week');
$monthStats = getSalesStats($pdo, 'month');

// Get low stock products
$lowStockProducts = getLowStockProducts($pdo);

// Get recent invoices
$stmt = $pdo->query("SELECT i.*, c.name as customer_name FROM invoices i 
    LEFT JOIN customers c ON i.customer_id = c.id 
    ORDER BY i.created_at DESC LIMIT 5");
$recentInvoices = $stmt->fetchAll();

// Get best selling products
$bestSelling = getBestSellingProducts($pdo, 5);

include 'includes/header.php';
?>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon primary">
            <i class="fas fa-chart-line"></i>
        </div>
        <div class="stat-label">Today's Sales</div>
        <div class="stat-value"><?php echo formatCurrency($todayStats['total_revenue'] ?? 0); ?></div>
        <div class="stat-footer">
            <small class="text-muted"><?php echo $todayStats['total_invoices'] ?? 0; ?> invoices</small>
            <a href="modules/invoices/list.php" class="stat-link">View All <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon success">
            <i class="fas fa-calendar-week"></i>
        </div>
        <div class="stat-label">This Week</div>
        <div class="stat-value"><?php echo formatCurrency($weekStats['total_revenue'] ?? 0); ?></div>
        <div class="stat-footer">
            <small class="text-muted"><?php echo $weekStats['total_invoices'] ?? 0; ?> invoices</small>
            <a href="modules/reports/index.php" class="stat-link">View Report <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon info">
            <i class="fas fa-calendar-alt"></i>
        </div>
        <div class="stat-label">This Month</div>
        <div class="stat-value"><?php echo formatCurrency($monthStats['total_revenue'] ?? 0); ?></div>
        <div class="stat-footer">
            <small class="text-muted"><?php echo $monthStats['total_invoices'] ?? 0; ?> invoices</small>
            <a href="modules/reports/index.php" class="stat-link">View Report <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon warning">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="stat-label">Low Stock Items</div>
        <div class="stat-value"><?php echo count($lowStockProducts); ?></div>
        <div class="stat-footer">
            <small class="text-muted">Need attention</small>
            <a href="modules/products/list.php" class="stat-link">View Products <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-file-invoice"></i> Recent Invoices
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Customer</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentInvoices as $invoice): ?>
                            <tr>
                                <td><a href="modules/invoices/view.php?id=<?php echo $invoice['id']; ?>" class="text-primary fw-bold"><?php echo $invoice['invoice_number']; ?></a></td>
                                <td><?php echo $invoice['customer_name'] ?? 'Walk-in'; ?></td>
                                <td><strong><?php echo formatCurrency($invoice['grand_total']); ?></strong></td>
                                <td>
                                    <span class="badge badge-<?php echo $invoice['payment_status'] === 'paid' ? 'success' : 'warning'; ?>">
                                        <i class="fas fa-<?php echo $invoice['payment_status'] === 'paid' ? 'check-circle' : 'clock'; ?>"></i>
                                        <?php echo ucfirst($invoice['payment_status']); ?>
                                    </span>
                                </td>
                                <td><?php echo formatDate($invoice['created_at'], 'M d, Y'); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <i class="fas fa-trophy"></i> Best Selling Products
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>SKU</th>
                                <th>Quantity Sold</th>
                                <th>Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($bestSelling as $product): ?>
                            <tr>
                                <td><strong><?php echo $product['name']; ?></strong></td>
                                <td><span class="text-muted"><?php echo $product['sku']; ?></span></td>
                                <td><span class="badge badge-info"><?php echo $product['total_sold']; ?></span></td>
                                <td><strong class="text-success"><?php echo formatCurrency($product['revenue']); ?></strong></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <i class="fas fa-exclamation-triangle"></i> Low Stock Alert
            </div>
            <div class="card-body">
                <?php if (empty($lowStockProducts)): ?>
                    <div class="text-center py-4">
                        <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                        <p class="text-muted">All products are well stocked!</p>
                    </div>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($lowStockProducts as $product): ?>
                        <div class="list-group-item px-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong class="d-block"><?php echo $product['name']; ?></strong>
                                    <small class="text-muted"><?php echo $product['sku']; ?></small>
                                </div>
                                <span class="badge badge-danger"><?php echo $product['quantity']; ?> left</span>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
