<?php
require_once '../../config/config.php';
requireLogin();

$pageTitle = 'Customers - ' . SITE_NAME;

$stmt = $pdo->query("SELECT * FROM customers ORDER BY name");
$customers = $stmt->fetchAll();

include '../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-users me-2"></i>Customers</h2>
    <a href="add.php" class="btn btn-primary"><i class="fas fa-plus-circle"></i> Add Customer</a>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> Customer List
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Address</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($customers as $customer): ?>
                    <tr>
                        <td data-label="Name"><strong><?php echo $customer['name']; ?></strong></td>
                        <td data-label="Phone"><i class="fas fa-phone text-muted me-1"></i><?php echo $customer['phone']; ?></td>
                        <td data-label="Email"><i class="fas fa-envelope text-muted me-1"></i><?php echo $customer['email']; ?></td>
                        <td data-label="Address"><i class="fas fa-map-marker-alt text-muted me-1"></i><?php echo $customer['address']; ?></td>
                        <td data-label="Actions">
                            <a href="edit.php?id=<?php echo $customer['id']; ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                            <?php if (isAdmin()): ?>
                            <a href="delete.php?id=<?php echo $customer['id']; ?>" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
