<?php
require_once '../../config/config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!validateCSRF($_POST['csrf_token'])) {
        setFlash('danger', 'Invalid request');
        redirect('list.php');
    }
    
    $invoice_id = intval($_POST['invoice_id']);
    $amount = floatval($_POST['amount']);
    $payment_method = $_POST['payment_method'];
    $reference_number = sanitize($_POST['reference_number']);
    
    try {
        $pdo->beginTransaction();
        
        // Insert payment
        $stmt = $pdo->prepare("INSERT INTO payments (invoice_id, amount, payment_method, reference_number) VALUES (?, ?, ?, ?)");
        $stmt->execute([$invoice_id, $amount, $payment_method, $reference_number]);
        
        // Update invoice
        $stmt = $pdo->prepare("UPDATE invoices SET amount_paid = amount_paid + ? WHERE id = ?");
        $stmt->execute([$amount, $invoice_id]);
        
        // Update payment status
        $stmt = $pdo->prepare("SELECT grand_total, amount_paid FROM invoices WHERE id = ?");
        $stmt->execute([$invoice_id]);
        $invoice = $stmt->fetch();
        
        if ($invoice['amount_paid'] >= $invoice['grand_total']) {
            $payment_status = 'paid';
        } elseif ($invoice['amount_paid'] > 0) {
            $payment_status = 'partial';
        } else {
            $payment_status = 'unpaid';
        }
        
        $stmt = $pdo->prepare("UPDATE invoices SET payment_status = ? WHERE id = ?");
        $stmt->execute([$payment_status, $invoice_id]);
        
        $pdo->commit();
        
        setFlash('success', 'Payment added successfully');
    } catch (Exception $e) {
        $pdo->rollBack();
        setFlash('danger', 'Error: ' . $e->getMessage());
    }
}

redirect('view.php?id=' . $invoice_id);
