<?php
require_once '../../config/config.php';
requireLogin();

$pageTitle = 'Invoices';

$stmt = $pdo->query("SELECT i.*, c.name as customer_name, u.name as user_name 
    FROM invoices i 
    LEFT JOIN customers c ON i.customer_id = c.id 
    LEFT JOIN users u ON i.user_id = u.id 
    ORDER BY i.created_at DESC");
$invoices = $stmt->fetchAll();

// Calculate summary statistics
$totalInvoices = count($invoices);
$totalRevenue = 0;
$totalPaid = 0;
$totalBalance = 0;
$paidCount = 0;
$unpaidCount = 0;
$partialCount = 0;

foreach ($invoices as $invoice) {
    $totalRevenue += $invoice['grand_total'];
    $totalPaid += $invoice['amount_paid'];
    $totalBalance += ($invoice['grand_total'] - $invoice['amount_paid']);
    
    if ($invoice['payment_status'] === 'paid') $paidCount++;
    elseif ($invoice['payment_status'] === 'partial') $partialCount++;
    else $unpaidCount++;
}

include '../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-invoice-dollar me-2"></i>Invoices</h2>
    <a href="create.php" class="btn btn-primary btn-lg"><i class="fas fa-plus-circle"></i> Create Invoice</a>
</div>

<!-- Summary Stats -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body">
                <div class="stat-icon primary mb-2">
                    <i class="fas fa-file-invoice"></i>
                </div>
                <h3 class="mb-1"><?php echo $totalInvoices; ?></h3>
                <small class="text-muted">Total Invoices</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body">
                <div class="stat-icon info mb-2">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <h3 class="mb-1"><?php echo formatCurrency($totalRevenue); ?></h3>
                <small class="text-muted">Total Revenue</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body">
                <div class="stat-icon success mb-2">
                    <i class="fas fa-check-circle"></i>
                </div>
                <h3 class="mb-1"><?php echo formatCurrency($totalPaid); ?></h3>
                <small class="text-muted">Total Paid</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body">
                <div class="stat-icon danger mb-2">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
                <h3 class="mb-1"><?php echo formatCurrency($totalBalance); ?></h3>
                <small class="text-muted">Outstanding Balance</small>
            </div>
        </div>
    </div>
</div>

<!-- Status Summary -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body text-center">
                <div class="d-inline-flex gap-3 flex-wrap justify-content-center">
                    <span class="badge badge-success" style="font-size: 1.1rem; padding: 0.75rem 2rem;">
                        <i class="fas fa-check-circle me-2"></i>Paid: <?php echo $paidCount; ?>
                    </span>
                    <span class="badge badge-warning" style="font-size: 1.1rem; padding: 0.75rem 2rem;">
                        <i class="fas fa-clock me-2"></i>Partial: <?php echo $partialCount; ?>
                    </span>
                    <span class="badge badge-danger" style="font-size: 1.1rem; padding: 0.75rem 2rem;">
                        <i class="fas fa-exclamation-circle me-2"></i>Unpaid: <?php echo $unpaidCount; ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <i class="fas fa-list"></i> Invoice List
        </div>
        <div>
            <input type="text" id="tableSearch" class="form-control form-control-sm" placeholder="Search invoices..." style="width: 250px;">
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Invoice #</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Paid</th>
                        <th>Balance</th>
                        <th>Payment Method</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($invoices)): ?>
                    <tr>
                        <td colspan="9" class="text-center py-5">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No invoices found. Create your first invoice!</p>
                            <a href="create.php" class="btn btn-primary mt-2">
                                <i class="fas fa-plus-circle"></i> Create Invoice
                            </a>
                        </td>
                    </tr>
                    <?php else: ?>
                        <?php foreach ($invoices as $invoice): ?>
                        <?php $balance = $invoice['grand_total'] - $invoice['amount_paid']; ?>
                        <tr>
                            <td data-label="Invoice #">
                                <strong class="text-primary"><?php echo $invoice['invoice_number']; ?></strong>
                            </td>
                            <td data-label="Customer">
                                <i class="fas fa-user text-muted me-1"></i>
                                <?php echo $invoice['customer_name'] ?? '<em>Walk-in</em>'; ?>
                            </td>
                            <td data-label="Amount"><strong><?php echo formatCurrency($invoice['grand_total']); ?></strong></td>
                            <td data-label="Paid"><span class="text-success fw-bold"><?php echo formatCurrency($invoice['amount_paid']); ?></span></td>
                            <td data-label="Balance">
                                <span class="fw-bold <?php echo $balance > 0 ? 'text-danger' : 'text-muted'; ?>">
                                    <?php echo formatCurrency($balance); ?>
                                </span>
                            </td>
                            <td data-label="Payment Method">
                                <span class="badge badge-secondary">
                                    <i class="fas fa-credit-card me-1"></i>
                                    <?php echo strtoupper($invoice['payment_method']); ?>
                                </span>
                            </td>
                            <td data-label="Status">
                                <span class="badge badge-<?php 
                                    echo $invoice['payment_status'] === 'paid' ? 'success' : 
                                        ($invoice['payment_status'] === 'partial' ? 'warning' : 'danger'); 
                                ?>">
                                    <i class="fas fa-<?php 
                                        echo $invoice['payment_status'] === 'paid' ? 'check-circle' : 
                                            ($invoice['payment_status'] === 'partial' ? 'clock' : 'exclamation-circle'); 
                                    ?>"></i>
                                    <?php echo ucfirst($invoice['payment_status']); ?>
                                </span>
                            </td>
                            <td data-label="Date">
                                <i class="fas fa-calendar text-muted me-1"></i>
                                <?php echo formatDate($invoice['created_at'], 'M d, Y'); ?>
                            </td>
                            <td data-label="Actions" class="text-nowrap">
                                <a href="view.php?id=<?php echo $invoice['id']; ?>" class="btn btn-sm btn-info" title="View Invoice">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="edit.php?id=<?php echo $invoice['id']; ?>" class="btn btn-sm btn-warning" title="Edit Invoice">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="print.php?id=<?php echo $invoice['id']; ?>" class="btn btn-sm btn-secondary" target="_blank" title="Print Invoice">
                                    <i class="fas fa-print"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
