<?php
require_once '../../config/config.php';
require_once '../../vendor/tcpdf/tcpdf.php';
requireLogin();

$id = intval($_GET['id']);

// Get invoice with customer details
$stmt = $pdo->prepare("SELECT i.*, c.name as customer_name, c.phone, c.email, c.address 
    FROM invoices i 
    LEFT JOIN customers c ON i.customer_id = c.id 
    WHERE i.id = ?");
$stmt->execute([$id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    die('Invoice not found');
}

// Get invoice items
$stmt = $pdo->prepare("SELECT * FROM invoice_items WHERE invoice_id = ?");
$stmt->execute([$id]);
$items = $stmt->fetchAll();

// Create PDF
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');
$pdf->SetCreator(SITE_NAME);
$pdf->SetAuthor(SITE_NAME);
$pdf->SetTitle('Invoice ' . $invoice['invoice_number']);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetMargins(15, 15, 15);
$pdf->AddPage();

// Build HTML content
$html = '
<h1 style="text-align:center;">' . SITE_NAME . '</h1>
<p style="text-align:center;">123 Business Street, City, State 12345<br>Phone: (123) 456-7890</p>
<hr>
<h2>INVOICE</h2>
<table cellpadding="5">
    <tr>
        <td width="50%"><strong>Invoice #:</strong> ' . $invoice['invoice_number'] . '</td>
        <td width="50%"><strong>Date:</strong> ' . formatDate($invoice['created_at'], 'M d, Y') . '</td>
    </tr>
</table>
<br>
<h3>Bill To:</h3>
<p><strong>' . ($invoice['customer_name'] ?? 'Walk-in Customer') . '</strong><br>';

if ($invoice['phone']) $html .= $invoice['phone'] . '<br>';
if ($invoice['email']) $html .= $invoice['email'] . '<br>';
if ($invoice['address']) $html .= nl2br($invoice['address']);

$html .= '</p><br>
<table border="1" cellpadding="5">
    <thead>
        <tr style="background-color:#f0f0f0;">
            <th width="50%"><strong>Product</strong></th>
            <th width="15%" align="center"><strong>Qty</strong></th>
            <th width="17%" align="right"><strong>Unit Price</strong></th>
            <th width="18%" align="right"><strong>Total</strong></th>
        </tr>
    </thead>
    <tbody>';

foreach ($items as $item) {
    $html .= '<tr>
        <td>' . $item['product_name'] . '</td>
        <td align="center">' . $item['quantity'] . '</td>
        <td align="right">' . formatCurrency($item['unit_price']) . '</td>
        <td align="right">' . formatCurrency($item['total']) . '</td>
    </tr>';
}

$html .= '</tbody>
    <tfoot>
        <tr>
            <td colspan="3" align="right"><strong>Subtotal:</strong></td>
            <td align="right">' . formatCurrency($invoice['subtotal']) . '</td>
        </tr>';

if ($invoice['discount'] > 0) {
    $html .= '<tr>
        <td colspan="3" align="right"><strong>Discount:</strong></td>
        <td align="right">-' . formatCurrency($invoice['discount']) . '</td>
    </tr>';
}

$html .= '<tr>
            <td colspan="3" align="right"><strong>Tax:</strong></td>
            <td align="right">' . formatCurrency($invoice['tax']) . '</td>
        </tr>
        <tr style="background-color:#e3f2fd;">
            <td colspan="3" align="right"><strong>Grand Total:</strong></td>
            <td align="right"><strong>' . formatCurrency($invoice['grand_total']) . '</strong></td>
        </tr>
        <tr>
            <td colspan="3" align="right"><strong>Amount Paid:</strong></td>
            <td align="right">' . formatCurrency($invoice['amount_paid']) . '</td>
        </tr>
        <tr>
            <td colspan="3" align="right"><strong>Balance Due:</strong></td>
            <td align="right"><strong>' . formatCurrency($invoice['grand_total'] - $invoice['amount_paid']) . '</strong></td>
        </tr>
    </tfoot>
</table>';

if ($invoice['notes']) {
    $html .= '<br><p><strong>Notes:</strong><br>' . nl2br($invoice['notes']) . '</p>';
}

$html .= '<br><br><p style="text-align:center; color:#666;">Thank you for your business!</p>';

$pdf->writeHTML($html, true, false, true, false, '');

$pdf->Output('invoice_' . $invoice['invoice_number'] . '.pdf', 'I');
