<?php
require_once '../../config/config.php';
requireLogin();

$id = intval($_GET['id']);

// Get invoice with customer details
$stmt = $pdo->prepare("SELECT i.*, c.name as customer_name, c.phone, c.email, c.address 
    FROM invoices i 
    LEFT JOIN customers c ON i.customer_id = c.id 
    WHERE i.id = ?");
$stmt->execute([$id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    die('Invoice not found');
}

// Get invoice items
$stmt = $pdo->prepare("SELECT * FROM invoice_items WHERE invoice_id = ?");
$stmt->execute([$id]);
$items = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice <?php echo $invoice['invoice_number']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none; }
        }
        body { background: white; }
        .invoice-box { max-width: 800px; margin: auto; padding: 30px; }
    </style>
</head>
<body>
    <div class="invoice-box">
        <div class="text-center mb-4 no-print">
            <button onclick="window.print()" class="btn btn-primary">Print Invoice</button>
            <a href="view.php?id=<?php echo $id; ?>" class="btn btn-secondary">Back</a>
        </div>
        
        <div class="border p-4">
            <div class="row mb-4">
                <div class="col-6">
                    <h2><?php echo SITE_NAME; ?></h2>
                    <p>123 Business Street<br>City, State 12345<br>Phone: (123) 456-7890</p>
                </div>
                <div class="col-6 text-end">
                    <h3>INVOICE</h3>
                    <p><strong>Invoice #:</strong> <?php echo $invoice['invoice_number']; ?><br>
                    <strong>Date:</strong> <?php echo formatDate($invoice['created_at'], 'M d, Y'); ?></p>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-6">
                    <h5>Bill To:</h5>
                    <p><strong><?php echo $invoice['customer_name'] ?? 'Walk-in Customer'; ?></strong><br>
                    <?php if ($invoice['phone']): ?>
                        <?php echo $invoice['phone']; ?><br>
                    <?php endif; ?>
                    <?php if ($invoice['email']): ?>
                        <?php echo $invoice['email']; ?><br>
                    <?php endif; ?>
                    <?php if ($invoice['address']): ?>
                        <?php echo nl2br($invoice['address']); ?>
                    <?php endif; ?>
                    </p>
                </div>
                <div class="col-6 text-end">
                    <p><strong>Payment Method:</strong> <?php echo strtoupper($invoice['payment_method']); ?><br>
                    <strong>Status:</strong> 
                    <span class="badge bg-<?php echo $invoice['payment_status'] === 'paid' ? 'success' : 'warning'; ?>">
                        <?php echo ucfirst($invoice['payment_status']); ?>
                    </span>
                    </p>
                </div>
            </div>
            
            <table class="table table-bordered">
                <thead class="table-light">
                    <tr>
                        <th>Product</th>
                        <th class="text-center">Qty</th>
                        <th class="text-end">Unit Price</th>
                        <th class="text-end">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($items as $item): ?>
                    <tr>
                        <td><?php echo $item['product_name']; ?></td>
                        <td class="text-center"><?php echo $item['quantity']; ?></td>
                        <td class="text-end"><?php echo formatCurrency($item['unit_price']); ?></td>
                        <td class="text-end"><?php echo formatCurrency($item['total']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="3" class="text-end"><strong>Subtotal:</strong></td>
                        <td class="text-end"><?php echo formatCurrency($invoice['subtotal']); ?></td>
                    </tr>
                    <?php if ($invoice['discount'] > 0): ?>
                    <tr>
                        <td colspan="3" class="text-end"><strong>Discount:</strong></td>
                        <td class="text-end">-<?php echo formatCurrency($invoice['discount']); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td colspan="3" class="text-end"><strong>Tax:</strong></td>
                        <td class="text-end"><?php echo formatCurrency($invoice['tax']); ?></td>
                    </tr>
                    <tr class="table-primary">
                        <td colspan="3" class="text-end"><strong>Grand Total:</strong></td>
                        <td class="text-end"><strong><?php echo formatCurrency($invoice['grand_total']); ?></strong></td>
                    </tr>
                    <tr>
                        <td colspan="3" class="text-end"><strong>Amount Paid:</strong></td>
                        <td class="text-end"><?php echo formatCurrency($invoice['amount_paid']); ?></td>
                    </tr>
                    <tr>
                        <td colspan="3" class="text-end"><strong>Balance Due:</strong></td>
                        <td class="text-end"><strong><?php echo formatCurrency($invoice['grand_total'] - $invoice['amount_paid']); ?></strong></td>
                    </tr>
                </tfoot>
            </table>
            
            <?php if ($invoice['notes']): ?>
            <div class="mt-3">
                <strong>Notes:</strong><br>
                <?php echo nl2br($invoice['notes']); ?>
            </div>
            <?php endif; ?>
            
            <div class="mt-5 text-center">
                <p class="text-muted">Thank you for your business!</p>
            </div>
        </div>
    </div>
</body>
</html>
