<?php
require_once '../../config/config.php';
requireLogin();

$id = intval($_GET['id']);

// Get invoice with customer details
$stmt = $pdo->prepare("SELECT i.*, c.name as customer_name, c.phone, c.email, c.address, u.name as user_name 
    FROM invoices i 
    LEFT JOIN customers c ON i.customer_id = c.id 
    LEFT JOIN users u ON i.user_id = u.id 
    WHERE i.id = ?");
$stmt->execute([$id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    setFlash('danger', 'Invoice not found');
    redirect('list.php');
}

// Get invoice items
$stmt = $pdo->prepare("SELECT * FROM invoice_items WHERE invoice_id = ?");
$stmt->execute([$id]);
$items = $stmt->fetchAll();

// Get payments
$stmt = $pdo->prepare("SELECT * FROM payments WHERE invoice_id = ? ORDER BY payment_date DESC");
$stmt->execute([$id]);
$payments = $stmt->fetchAll();

$balance = $invoice['grand_total'] - $invoice['amount_paid'];

$pageTitle = 'Invoice ' . $invoice['invoice_number'];

include '../../includes/header.php';
?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4><i class="fas fa-file-invoice me-2"></i>Invoice Details</h4>
                <div>
                    <a href="edit.php?id=<?php echo $id; ?>" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="print.php?id=<?php echo $id; ?>" class="btn btn-secondary" target="_blank">
                        <i class="fas fa-print"></i> Print
                    </a>
                    <a href="pdf.php?id=<?php echo $id; ?>" class="btn btn-danger">
                        <i class="fas fa-file-pdf"></i> PDF
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h5 class="text-primary">Invoice #<?php echo $invoice['invoice_number']; ?></h5>
                        <p class="mb-1"><i class="fas fa-calendar text-muted me-2"></i><strong>Date:</strong> <?php echo formatDate($invoice['created_at'], 'M d, Y'); ?></p>
                        <p class="mb-1"><i class="fas fa-user text-muted me-2"></i><strong>Created by:</strong> <?php echo $invoice['user_name']; ?></p>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h6 class="mb-2"><i class="fas fa-user-circle me-1"></i>Customer Details</h6>
                                <p class="mb-1"><strong><?php echo $invoice['customer_name'] ?? 'Walk-in Customer'; ?></strong></p>
                                <?php if ($invoice['phone']): ?>
                                    <p class="mb-1"><i class="fas fa-phone text-muted me-2"></i><?php echo $invoice['phone']; ?></p>
                                <?php endif; ?>
                                <?php if ($invoice['email']): ?>
                                    <p class="mb-1"><i class="fas fa-envelope text-muted me-2"></i><?php echo $invoice['email']; ?></p>
                                <?php endif; ?>
                                <?php if ($invoice['address']): ?>
                                    <p class="mb-0"><i class="fas fa-map-marker-alt text-muted me-2"></i><?php echo $invoice['address']; ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="table-responsive mb-4">
                    <table class="table table-bordered">
                        <thead class="table-light">
                            <tr>
                                <th>Product</th>
                                <th class="text-center">Quantity</th>
                                <th class="text-end">Unit Price</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($items as $item): ?>
                            <tr>
                                <td><?php echo $item['product_name']; ?></td>
                                <td class="text-center"><span class="badge badge-info"><?php echo $item['quantity']; ?></span></td>
                                <td class="text-end"><?php echo formatCurrency($item['unit_price']); ?></td>
                                <td class="text-end"><strong><?php echo formatCurrency($item['total']); ?></strong></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="3" class="text-end"><strong>Subtotal:</strong></td>
                                <td class="text-end"><?php echo formatCurrency($invoice['subtotal']); ?></td>
                            </tr>
                            <?php if ($invoice['discount'] > 0): ?>
                            <tr>
                                <td colspan="3" class="text-end"><strong>Discount:</strong></td>
                                <td class="text-end text-danger">-<?php echo formatCurrency($invoice['discount']); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td colspan="3" class="text-end"><strong>Tax (<?php echo TAX_RATE; ?>%):</strong></td>
                                <td class="text-end"><?php echo formatCurrency($invoice['tax']); ?></td>
                            </tr>
                            <tr class="table-primary">
                                <td colspan="3" class="text-end"><strong><i class="fas fa-calculator me-2"></i>Grand Total:</strong></td>
                                <td class="text-end"><strong><?php echo formatCurrency($invoice['grand_total']); ?></strong></td>
                            </tr>
                            <tr class="table-success">
                                <td colspan="3" class="text-end"><strong><i class="fas fa-money-bill-wave me-2"></i>Amount Paid:</strong></td>
                                <td class="text-end text-success"><strong><?php echo formatCurrency($invoice['amount_paid']); ?></strong></td>
                            </tr>
                            <tr class="<?php echo $balance > 0 ? 'table-warning' : 'table-light'; ?>">
                                <td colspan="3" class="text-end"><strong><i class="fas fa-balance-scale me-2"></i>Balance:</strong></td>
                                <td class="text-end <?php echo $balance > 0 ? 'text-danger' : 'text-success'; ?>"><strong><?php echo formatCurrency($balance); ?></strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                
                <?php if ($invoice['notes']): ?>
                <div class="alert alert-info">
                    <i class="fas fa-sticky-note me-2"></i><strong>Notes:</strong> <?php echo $invoice['notes']; ?>
                </div>
                <?php endif; ?>
                
                <div class="d-flex justify-content-between">
                    <a href="list.php" class="btn btn-secondary"><i class="fas fa-arrow-left me-1"></i> Back to List</a>
                    <?php if ($balance > 0): ?>
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#paymentModal">
                            <i class="fas fa-money-bill-wave me-1"></i> Add Payment
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-header">
                <i class="fas fa-info-circle"></i> Payment Status
            </div>
            <div class="card-body text-center">
                <h3>
                    <span class="badge badge-<?php 
                        echo $invoice['payment_status'] === 'paid' ? 'success' : 
                            ($invoice['payment_status'] === 'partial' ? 'warning' : 'danger'); 
                    ?>">
                        <i class="fas fa-<?php 
                            echo $invoice['payment_status'] === 'paid' ? 'check-circle' : 
                                ($invoice['payment_status'] === 'partial' ? 'clock' : 'exclamation-circle'); 
                        ?>"></i>
                        <?php echo ucfirst($invoice['payment_status']); ?>
                    </span>
                </h3>
                <p class="mb-1 mt-3"><i class="fas fa-credit-card text-muted me-2"></i><strong>Payment Method:</strong> <span class="badge badge-secondary"><?php echo strtoupper($invoice['payment_method']); ?></span></p>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <i class="fas fa-history"></i> Payment History
            </div>
            <div class="card-body">
                <?php if (empty($payments)): ?>
                    <div class="text-center py-3">
                        <i class="fas fa-receipt fa-3x text-muted mb-2"></i>
                        <p class="text-muted mb-0">No payments recorded</p>
                    </div>
                <?php else: ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($payments as $payment): ?>
                        <div class="list-group-item px-0">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <strong class="text-success"><i class="fas fa-check-circle me-1"></i><?php echo formatCurrency($payment['amount']); ?></strong>
                                <small class="text-muted"><?php echo formatDate($payment['payment_date'], 'M d, Y'); ?></small>
                            </div>
                            <small><i class="fas fa-credit-card text-muted me-1"></i><?php echo strtoupper($payment['payment_method']); ?></small>
                            <?php if ($payment['reference_number']): ?>
                                <br><small class="text-muted"><i class="fas fa-hashtag me-1"></i>Ref: <?php echo $payment['reference_number']; ?></small>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="add_payment.php">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <input type="hidden" name="invoice_id" value="<?php echo $id; ?>">
                
                <div class="modal-header">
                    <h5 class="modal-title">Add Payment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Outstanding Balance</label>
                        <input type="text" class="form-control" value="<?php echo formatCurrency($balance); ?>" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Amount *</label>
                        <input type="number" step="0.01" name="amount" class="form-control" max="<?php echo $balance; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Payment Method *</label>
                        <select name="payment_method" class="form-select" required>
                            <option value="cash">Cash</option>
                            <option value="transfer">Transfer</option>
                            <option value="pos">POS</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Reference Number</label>
                        <input type="text" name="reference_number" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
