<?php
require_once '../../config/config.php';
requireLogin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect('list.php');
}

if (!validateCSRF($_POST['csrf_token'])) {
    setFlash('danger', 'Invalid request');
    redirect('list.php');
}

$order_id = intval($_POST['order_id']);
$notes = sanitize($_POST['notes']);

try {
    $stmt = $pdo->prepare("UPDATE shop_orders SET notes = ? WHERE id = ?");
    $stmt->execute([$notes, $order_id]);
    
    setFlash('success', 'Notes updated successfully');
} catch (PDOException $e) {
    setFlash('danger', 'Error updating notes: ' . $e->getMessage());
}

redirect('view.php?id=' . $order_id);
