<?php
require_once '../../config/config.php';
requireLogin();

$pageTitle = 'Shop Orders';

// Get all shop orders
$stmt = $pdo->query("SELECT so.*, p.name as product_name_current, p.image as product_image 
    FROM shop_orders so
    LEFT JOIN products p ON so.product_id = p.id
    ORDER BY so.order_date DESC");
$orders = $stmt->fetchAll();

// Get statistics
$stmt = $pdo->query("SELECT 
    COUNT(*) as total_orders,
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_orders,
    SUM(CASE WHEN status = 'delivered' THEN 1 ELSE 0 END) as delivered_orders,
    SUM(total_amount) as total_revenue
    FROM shop_orders");
$stats = $stmt->fetch();

include '../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-shopping-bag me-2"></i>Shop Orders</h2>
</div>

<!-- Statistics Cards -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-icon primary">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-label">Total Orders</div>
        <div class="stat-value"><?php echo $stats['total_orders']; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon warning">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-label">Pending Orders</div>
        <div class="stat-value"><?php echo $stats['pending_orders']; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon success">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-label">Delivered</div>
        <div class="stat-value"><?php echo $stats['delivered_orders']; ?></div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon info">
            <i class="fas fa-money-bill-wave"></i>
        </div>
        <div class="stat-label">Total Revenue</div>
        <div class="stat-value"><?php echo formatCurrency($stats['total_revenue']); ?></div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> Orders List
    </div>
    <div class="card-body">
        <?php if (empty($orders)): ?>
            <div class="text-center py-5">
                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                <p class="text-muted">No orders yet</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>Date</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>Quantity</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $order): ?>
                        <tr>
                            <td data-label="Order ID"><strong>#<?php echo $order['id']; ?></strong></td>
                            <td data-label="Date"><?php echo date('M d, Y H:i', strtotime($order['order_date'])); ?></td>
                            <td data-label="Customer">
                                <i class="fas fa-user text-muted me-1"></i><?php echo $order['customer_name']; ?>
                            </td>
                            <td data-label="Phone">
                                <i class="fas fa-phone text-muted me-1"></i><?php echo $order['customer_phone']; ?>
                            </td>
                            <td data-label="Product"><?php echo $order['product_name']; ?></td>
                            <td data-label="Quantity">
                                <span class="badge badge-info"><?php echo $order['quantity']; ?></span>
                            </td>
                            <td data-label="Total">
                                <strong style="color: #76ba3f;"><?php echo formatCurrency($order['total_amount']); ?></strong>
                            </td>
                            <td data-label="Status">
                                <?php
                                $statusColors = [
                                    'pending' => 'warning',
                                    'confirmed' => 'info',
                                    'processing' => 'primary',
                                    'delivered' => 'success',
                                    'cancelled' => 'danger'
                                ];
                                $statusIcons = [
                                    'pending' => 'clock',
                                    'confirmed' => 'check',
                                    'processing' => 'cog',
                                    'delivered' => 'check-circle',
                                    'cancelled' => 'times-circle'
                                ];
                                $color = $statusColors[$order['status']] ?? 'secondary';
                                $icon = $statusIcons[$order['status']] ?? 'question';
                                ?>
                                <span class="badge badge-<?php echo $color; ?>">
                                    <i class="fas fa-<?php echo $icon; ?>"></i> <?php echo ucfirst($order['status']); ?>
                                </span>
                            </td>
                            <td data-label="Actions">
                                <a href="view.php?id=<?php echo $order['id']; ?>" class="btn btn-sm btn-primary" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if ($order['status'] === 'pending'): ?>
                                <a href="update-status.php?id=<?php echo $order['id']; ?>&status=confirmed" class="btn btn-sm btn-success" title="Confirm Order">
                                    <i class="fas fa-check"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
