<?php
require_once '../../config/config.php';
requireAdmin();

$id = intval($_GET['id']);

try {
    // Get product image before deleting
    $stmt = $pdo->prepare("SELECT image FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $product = $stmt->fetch();
    
    // Delete the product
    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    $stmt->execute([$id]);
    
    // Delete the image file if exists
    if ($product && $product['image'] && file_exists('../../uploads/' . $product['image'])) {
        unlink('../../uploads/' . $product['image']);
    }
    
    setFlash('success', 'Product deleted successfully');
} catch (PDOException $e) {
    setFlash('danger', 'Error deleting product: ' . $e->getMessage());
}

redirect('list.php');
