<?php
require_once '../../config/config.php';
requireLogin();

$pageTitle = 'Products - ' . SITE_NAME;

// Get all products with category
$stmt = $pdo->query("SELECT p.*, c.name as category_name FROM products p 
    LEFT JOIN categories c ON p.category_id = c.id 
    ORDER BY p.date_added DESC");
$products = $stmt->fetchAll();

include '../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-box me-2"></i>Products</h2>
    <a href="add.php" class="btn btn-primary btn-lg"><i class="fas fa-plus-circle"></i> Add Product</a>
</div>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <div>
            <i class="fas fa-list"></i> Product List
        </div>
    </div>
    <div class="card-body">
        <?php if (empty($products)): ?>
            <div class="text-center py-5">
                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                <p class="text-muted">No products found. Add your first product!</p>
                <a href="add.php" class="btn btn-primary mt-2">
                    <i class="fas fa-plus-circle"></i> Add Product
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>SKU</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Cost Price</th>
                            <th>Selling Price</th>
                            <th>Stock</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($products as $product): ?>
                        <tr>
                            <td data-label="Image">
                                <?php if (!empty($product['image']) && file_exists('../../uploads/' . $product['image'])): ?>
                                    <img src="../../uploads/<?php echo $product['image']; ?>" alt="<?php echo $product['name']; ?>" class="product-thumbnail">
                                <?php else: ?>
                                    <div class="product-thumbnail-placeholder">
                                        <i class="fas fa-image"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td data-label="SKU"><strong><?php echo $product['sku']; ?></strong></td>
                            <td data-label="Name"><?php echo $product['name']; ?></td>
                            <td data-label="Category">
                                <span class="badge badge-info"><?php echo $product['category_name'] ?? 'N/A'; ?></span>
                            </td>
                            <td data-label="Cost Price"><?php echo formatCurrency($product['cost_price']); ?></td>
                            <td data-label="Selling Price"><strong><?php echo formatCurrency($product['selling_price']); ?></strong></td>
                            <td data-label="Stock">
                                <span class="badge badge-<?php echo $product['quantity'] <= $product['reorder_level'] ? 'danger' : 'success'; ?>">
                                    <?php echo $product['quantity']; ?>
                                </span>
                            </td>
                            <td data-label="Status">
                                <?php if ($product['quantity'] <= $product['reorder_level']): ?>
                                    <span class="badge badge-warning">
                                        <i class="fas fa-exclamation-triangle"></i> Low Stock
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success">
                                        <i class="fas fa-check-circle"></i> In Stock
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td data-label="Actions">
                                <a href="edit.php?id=<?php echo $product['id']; ?>" class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php if (isAdmin()): ?>
                                <a href="delete.php?id=<?php echo $product['id']; ?>" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i>
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
