<?php
require_once '../../config/config.php';
requireLogin();

$pageTitle = 'Reports - ' . SITE_NAME;

// Get date range from request or default to this month
$start_date = $_GET['start_date'] ?? date('Y-m-01');
$end_date = $_GET['end_date'] ?? date('Y-m-t');

// Sales summary
$stmt = $pdo->prepare("SELECT 
    COUNT(*) as total_invoices,
    SUM(grand_total) as total_revenue,
    SUM(CASE WHEN payment_status = 'paid' THEN grand_total ELSE 0 END) as paid_amount,
    SUM(CASE WHEN payment_status = 'unpaid' THEN grand_total ELSE 0 END) as unpaid_amount,
    SUM(CASE WHEN payment_status = 'partial' THEN grand_total ELSE 0 END) as partial_amount
    FROM invoices 
    WHERE DATE(created_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$summary = $stmt->fetch();

// Daily sales
$stmt = $pdo->prepare("SELECT DATE(created_at) as date, COUNT(*) as invoices, SUM(grand_total) as revenue
    FROM invoices 
    WHERE DATE(created_at) BETWEEN ? AND ?
    GROUP BY DATE(created_at)
    ORDER BY date DESC");
$stmt->execute([$start_date, $end_date]);
$dailySales = $stmt->fetchAll();

// Top products
$stmt = $pdo->prepare("SELECT p.name, p.sku, SUM(ii.quantity) as total_sold, SUM(ii.total) as revenue
    FROM invoice_items ii
    JOIN products p ON ii.product_id = p.id
    JOIN invoices i ON ii.invoice_id = i.id
    WHERE DATE(i.created_at) BETWEEN ? AND ?
    GROUP BY ii.product_id
    ORDER BY total_sold DESC
    LIMIT 10");
$stmt->execute([$start_date, $end_date]);
$topProducts = $stmt->fetchAll();

// Low stock products
$lowStock = getLowStockProducts($pdo);

include '../../includes/header.php';
?>

<h2><i class="fas fa-chart-bar me-2"></i>Sales Reports</h2>

<div class="card mb-4">
    <div class="card-header">
        <i class="fas fa-filter"></i> Filter Reports
    </div>
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label"><i class="fas fa-calendar-alt me-1"></i>Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label"><i class="fas fa-calendar-alt me-1"></i>End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary d-block w-100">
                    <i class="fas fa-search"></i> Generate Report
                </button>
            </div>
        </form>
    </div>
</div>

<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-icon primary">
            <i class="fas fa-file-invoice"></i>
        </div>
        <div class="stat-label">Total Invoices</div>
        <div class="stat-value"><?php echo $summary['total_invoices'] ?? 0; ?></div>
    </div>
    <div class="stat-card">
        <div class="stat-icon success">
            <i class="fas fa-dollar-sign"></i>
        </div>
        <div class="stat-label">Total Revenue</div>
        <div class="stat-value"><?php echo formatCurrency($summary['total_revenue'] ?? 0); ?></div>
    </div>
    <div class="stat-card">
        <div class="stat-icon info">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-label">Paid Amount</div>
        <div class="stat-value"><?php echo formatCurrency($summary['paid_amount'] ?? 0); ?></div>
    </div>
    <div class="stat-card">
        <div class="stat-icon warning">
            <i class="fas fa-exclamation-circle"></i>
        </div>
        <div class="stat-label">Unpaid Amount</div>
        <div class="stat-value"><?php echo formatCurrency($summary['unpaid_amount'] ?? 0); ?></div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Daily Sales</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Invoices</th>
                                <th>Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($dailySales as $day): ?>
                            <tr>
                                <td><?php echo formatDate($day['date'], 'M d, Y'); ?></td>
                                <td><?php echo $day['invoices']; ?></td>
                                <td><?php echo formatCurrency($day['revenue']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Top Selling Products</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Sold</th>
                                <th>Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($topProducts as $product): ?>
                            <tr>
                                <td><?php echo $product['name']; ?></td>
                                <td><?php echo $product['total_sold']; ?></td>
                                <td><?php echo formatCurrency($product['revenue']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-warning text-white">
        <h5 class="mb-0">Low Stock Alert</h5>
    </div>
    <div class="card-body">
        <?php if (empty($lowStock)): ?>
            <p class="text-muted">All products are well stocked!</p>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>SKU</th>
                            <th>Current Stock</th>
                            <th>Reorder Level</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($lowStock as $product): ?>
                        <tr>
                            <td><?php echo $product['name']; ?></td>
                            <td><?php echo $product['sku']; ?></td>
                            <td><span class="badge bg-danger"><?php echo $product['quantity']; ?></span></td>
                            <td><?php echo $product['reorder_level']; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
