<?php
require_once '../../config/config.php';
requireAdmin();

$id = intval($_GET['id']);

// Prevent deleting own account
if ($id == $_SESSION['user_id']) {
    setFlash('danger', 'You cannot delete your own account');
    redirect('list.php');
}

try {
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$id]);
    
    setFlash('success', 'User deleted successfully');
} catch (PDOException $e) {
    setFlash('danger', 'Error deleting user: ' . $e->getMessage());
}

redirect('list.php');
