<?php
require_once '../../config/config.php';
requireAdmin();

$pageTitle = 'Users - ' . SITE_NAME;

$stmt = $pdo->query("SELECT * FROM users ORDER BY created_at DESC");
$users = $stmt->fetchAll();

include '../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-shield me-2"></i>Users</h2>
    <a href="add.php" class="btn btn-primary"><i class="fas fa-plus-circle"></i> Add User</a>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> User List
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td data-label="Name"><strong><?php echo $user['name']; ?></strong></td>
                        <td data-label="Email"><i class="fas fa-envelope text-muted me-1"></i><?php echo $user['email']; ?></td>
                        <td data-label="Role">
                            <span class="badge badge-<?php echo $user['role'] === 'admin' ? 'danger' : 'info'; ?>">
                                <i class="fas fa-<?php echo $user['role'] === 'admin' ? 'user-shield' : 'user'; ?>"></i>
                                <?php echo ucfirst($user['role']); ?>
                            </span>
                        </td>
                        <td data-label="Status">
                            <span class="badge badge-<?php echo $user['status'] === 'active' ? 'success' : 'secondary'; ?>">
                                <i class="fas fa-<?php echo $user['status'] === 'active' ? 'check-circle' : 'ban'; ?>"></i>
                                <?php echo ucfirst($user['status']); ?>
                            </span>
                        </td>
                        <td data-label="Created"><?php echo formatDate($user['created_at'], 'M d, Y'); ?></td>
                        <td data-label="Actions">
                            <a href="edit.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                            <?php if ($user['id'] != $_SESSION['user_id']): ?>
                            <a href="delete.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../../includes/footer.php'; ?>
