<?php
require_once 'config/config.php';

$pageTitle = 'Shop';

// Get all products (only in stock)
try {
    $stmt = $pdo->query("SELECT * FROM products 
        WHERE quantity > 0
        ORDER BY date_added DESC");
    $products = $stmt->fetchAll();
} catch (Exception $e) {
    $products = [];
    error_log("Shop error: " . $e->getMessage());
}

include 'includes/shop-header.php';
?>

<!-- Hero Section -->
<div class="card mb-4">
    <div class="card-body text-center py-5" style="background: linear-gradient(135deg, #033a71 0%, #0d5aa7 100%); color: white;">
        <h1 class="display-4 mb-3" style="color: white !important;"><i class="fas fa-store me-3"></i>Welcome to Our Store</h1>
        <p class="lead mb-4" style="color: white;">Discover amazing products at great prices</p>
        <a href="#products" class="btn btn-light btn-lg">
            <i class="fas fa-shopping-bag"></i> Browse Products
        </a>
    </div>
</div>

<!-- Products Section -->
<div class="card" id="products">
    <div class="card-header">
        <h4 class="mb-0"><i class="fas fa-box me-2"></i>Our Products</h4>
    </div>
    <div class="card-body">
        <?php if (empty($products)): ?>
            <div class="text-center py-5">
                <i class="fas fa-box-open fa-4x text-muted mb-3"></i>
                <h3>No Products Available</h3>
                <p class="text-muted">Check back soon for new products!</p>
            </div>
        <?php else: ?>
            <div class="row g-4">
                <?php foreach ($products as $product): ?>
                <div class="col-md-4 col-lg-3">
                    <div class="card h-100 product-card-hover">
                        <div class="position-relative">
                            <?php if (!empty($product['image']) && file_exists('uploads/' . $product['image'])): ?>
                                <img src="uploads/<?php echo $product['image']; ?>" class="card-img-top" alt="<?php echo $product['name']; ?>" style="height: 200px; object-fit: cover;">
                            <?php else: ?>
                                <div class="card-img-top d-flex align-items-center justify-content-center bg-light" style="height: 200px;">
                                    <i class="fas fa-image fa-3x text-muted"></i>
                                </div>
                            <?php endif; ?>
                            <?php if ($product['quantity'] <= $product['reorder_level']): ?>
                                <span class="badge bg-warning position-absolute top-0 end-0 m-2">Low Stock</span>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title"><?php echo htmlspecialchars($product['name']); ?></h5>
                            <p class="card-text text-muted small"><?php echo substr($product['description'], 0, 60); ?><?php echo strlen($product['description']) > 60 ? '...' : ''; ?></p>
                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <h4 class="text-primary mb-0"><?php echo formatCurrency($product['selling_price']); ?></h4>
                                <button class="btn btn-primary btn-buy-now" 
                                        data-id="<?php echo $product['id']; ?>"
                                        data-name="<?php echo htmlspecialchars($product['name']); ?>"
                                        data-price="<?php echo $product['selling_price']; ?>"
                                        data-image="<?php echo $product['image']; ?>"
                                        data-stock="<?php echo $product['quantity']; ?>">
                                    <i class="fas fa-shopping-bag"></i> Buy
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.product-card-hover {
    transition: all 0.3s;
}
.product-card-hover:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
}

/* Dark mode styles for shop */
body.dark-mode .card-title {
    color: #e4e6eb !important;
}

body.dark-mode h5.card-title {
    color: #e4e6eb !important;
}

body.dark-mode .product-card-hover .card-title {
    color: #e4e6eb !important;
}

body.dark-mode .card-text {
    color: #b0b3b8 !important;
}
</style>

<?php include 'includes/shop-footer.php'; ?>
